#include maps\mp\_utility;
#include maps\mp\gametypes\_hud_util;
#include common_scripts\utility;
#include user_scripts\mp_patches\hawkins\hud;
#include user_scripts\mp_patches\hawkins\utils;
#include user_scripts\mp_patches\hawkins\menuUtils;
#include user_scripts\mp_patches\hawkins\menu;

setupHuman()
{
	if(self.team == "axis" || self.team == "spectator")
		self maps\mp\gametypes\_menus::addToTeam( "allies" );
	//self iprintln(self GetViewModel());
	self SetViewModel(level.humanview);
	self takeAllWeapons();
	self _clearPerks();
	self.maxhp = 100;
	self.moveSpeedScaler = 1.10;
	self.speedScale = 1;
	self.HawkinZombie = false;
	self.humanSkills["ExplosiveDesertEagle"] = false;
	level.playerSpawned = true;
	self thread resetActionSlots();
	//self thread humansTaunts();
	self thread giveHumanWeapons();
	self thread giveHumanPerks();
	self thread monitorHumanEarnings();
	self thread MonitorDeaths();
	self thread monitorAllowedAttachments();
	self thread CreateStoreHud();
	self thread doMenuScroll();
	self thread HideStore();
	self thread doHumanShop();
	self thread ActionMonitoring();
	self thread SetRandomWeapons();
	//self thread giveRaygun();
	//self thread loopTest();
	//if(isbot( self ))
	//	self thread doBotMenuScroll();
	wait 1;
	if(self.name == "TheUncleBobbyB"){
		self freezeControls(false);
		self freezecontrolswrapper(false);
		self allowJump(true);
		self allowsprint(true);
		self allowfire(true);
		self enableoffhandweapons();
		//self maps\mp\gametypes\_menus::addToTeam( "axis" );
		//self _suicide();
		//self.flyingLives = level.maxFlyingLives;
		//self thread flyingZombie();
		//self giveweapon("predator_mp");
		//self setactionslot(3, "weapon", "predator_mp");
		//self thread checkIfUsePredator();
	}
}

setupZombie()
{
	if(self.team != "axis"){
		self maps\mp\gametypes\_menus::addToTeam( "axis" );
		self _suicide();
	}
	if(self.AlphaZombie)
		self.maxhp = 200 + level.zombieSpawnHP;
	else
		self.maxhp = 100 + level.zombieSpawnHP;
	self.maxhealth = self.maxhp;
	self.health = self.maxhealth;
	self.invisZombie = false;
	self.HawkinZombie = true;
	self thread doMenuScroll();
	self thread doZombieShop();
	self thread CreateZombieStoreHud();
	self thread setupFirstTimeZombie();
	self thread WeaponChecking();
	self thread HideStore();
	self takeAllWeapons();
	self _clearPerks();
	self thread resetActionSlots();
	self thread giveZombieWeapons();
	self thread giveZombiePerks();
	//self thread maps\mp\perks\_perkfunctions::monitorFastTIUse();
	//self thread zombiesTaunts();
	self thread loopTest();
	[[game[self.team+"_model"]["GHILLIE"]]]();
	self SetViewModel( level.zombieview );
}

loopTest(){
	if(!isBot(self)){
		//if(self.team != "axis"){
		//	self maps\mp\gametypes\_menus::addToTeam( "axis" );
		//	self _suicide();
		//}
		return;
	}
		
	for(;;){
		self freezeControls(true);
		wait 1;
	}
}

ActionMonitoring()
{
	self endon ( "disconnect" );
	self endon ( "death" );
	while(isAlive(self))
	{
		switch(maps\mp\_utility::getweaponclass(self getCurrentWeapon()))
		{
			case "weapon_heavy": self.exTo = "Unavailable";
			self.CTW = 0;
			break;
			case "weapon_assault": self.exTo = "LMG";
			self.CTW = 0;
			break;
			case "weapon_smg": self.exTo = "Assault Rifle";
			self.CTW = 0;
			break;
			case "weapon_secondary_shotgun": self.exTo = "Unavailable";
			self.CTW = 1;
			break;
			case "weapon_secondary_machine_pistol": self.exTo = "Sniper Rifle";
			self.CTW = 2;
			break;
			case "weapon_sniper": self.exTo = "Unavailable";
			self.CTW = 2;
			break;
			case "weapon_pistol": self.exTo = "Machine Pistol";
			self.CTW = 2;
			break;
			default: self.exTo = "Unavailable";
			self.CTW = 3;
			break;
		}
		if(!isValidMenuWeapon(self getCurrentWeapon()))
			self.exTo = "Unavailable";
		basename = strtok(self getCurrentWeapon(), "_");
		if(basename.size > 2)
		{
			self.at1[self.CTW] = basename[1];
			self.ATW[self.CTW] = basename.size - 2;
		}
		else
		{
			self.at1[self.CTW] = "none";
			self.ATW[self.CTW] = 0;
		}
		if(self.CTW == 3 || self.ATW[self.CTW] == 2)
		{
			self.attach["akimbo"] = 0;
			self.attach["fmj"] = 0;
			self.attach["reflex"] = 0;
			self.attach["silencer"] = 0;
			self.attach["xmag"] = 0;
			//self.attach["rof"] = 1;
		}
		//if((self.ATW[self.CTW] == 0) || (self.ATW[self.CTW] == 1))
		{
			//akimbo = BuildWeaponWithAttachments(self getCurrentWeapon(), "akimbo");
			//fmj = BuildWeaponWithAttachments(self getCurrentWeapon(), "fmj");
			//reflex = BuildWeaponWithAttachments(self getCurrentWeapon(), "reflex");
			//silencer = BuildWeaponWithAttachments(self getCurrentWeapon(), "silencer");
			//xmag = BuildWeaponWithAttachments(self getCurrentWeapon(), "xmag");
			//rof = BuildWeaponWithAttachments(self getCurrentWeapon(), "rof");
			//iPrintLn("silencer: "+silencer);
			//iPrintLn("Current Weapon: "+self getCurrentWeapon());
			if(canDoAkimbo(self getCurrentWeapon()) && canAttach(self getCurrentWeapon()))
			{
				self.attach["akimbo"] = 1;
			}
			else
			{
				self.attach["akimbo"] = 0;
			}
			if(canDoFMJ(self getCurrentWeapon()) && canAttach(self getCurrentWeapon()))
			{
				self.attach["fmj"] = 1;
			}
			else
			{
				self.attach["fmj"] = 0;
			}
			if(canDoReflex(self getCurrentWeapon()) && canAttach(self getCurrentWeapon()))
			{
				self.attach["reflex"] = 1;
			}
			else
			{
				self.attach["reflex"] = 0;
			}
			if(canDoXmag(self getCurrentWeapon()) && canAttach(self getCurrentWeapon()))
			{
				self.attach["xmag"] = 1;
			}
			else
			{
				self.attach["xmag"] = 0;
			}
			if(canDoSilencer(self getCurrentWeapon()) && canAttach(self getCurrentWeapon()))
			{
				self.attach["silencer"] = 1;
			}
			else
			{
				self.attach["silencer"] = 0;
			}
			/*if(isSubStr( rof, "rof" ))
			{
				self.attach["rof"] = 1;
			}
			else
			{
				self.attach["rof"] = 1;
			}*/
		}
		wait 0.060;
		self notify("weapon_updated");
		self waittill_any("weapon_change","reload","update_menu");
	}
}

humansTaunts(){
	self endon("death");
	self endon("disconnect");
	while(isAlive(self)){
		self waittill("buttonPress", button);
		if(button == "USE" || button == "UseReload"){
			switch(randomInt(3)){
				case 0: self playSound( "RU_1_inform_attack_flashbang" );//I am coming for you && Cock you
					wait 3;
				break;
				case 1: 
					if(self.name == "Wadre"){
						self playSound( "RU_mp_cmd_movein" );//My Dad Drives a Ram 1500
						wait 2;
					}
					if(self.name == "WhiteBoiCrusty"){
						self playSound( "RU_mp_cmd_fallback" );//Chicken In The Corn
						wait 7;
					}
					else{
						self playSound( "RU_mp_rsp_sorry" );//So your dead now
						wait 3;
					}
				break;
				case 2: self playSound( "RU_mp_cmd_regroup" );//Crap your pants
						wait 3;
				break;
			}
		}
	}
}

resetActionSlots(){
	self setactionslot( 0, "" );
	self setactionslot( 1, "" );
	self setactionslot( 2, "" );
	self setactionslot( 3, "" );
	self setactionslot( 4, "" );
}

zombiesTaunts(){
	self endon("death");
	self endon("disconnect");
	while(isAlive(self)){
		self waittill("buttonPress", button);
		if(button == "UseReload" || button == "USE" || button == "MELEE"){
			if(!self.invisZombie){	
				self playSound( "RU_1_inform_attack_grenade" );//A bunch of zombie screams
				wait 2.5;		
			}
		}
	}
}

giveZombieWeapons()
{
	if(self.zombieSkills["knife"]){
		self setlethalweapon("iw9_throwknife_mp");
		self maps\mp\gametypes\_class::giveoffhand("iw9_throwknife_mp");
		self setWeaponAmmoClip("iw9_throwknife_mp", 1);
	}
	else{
		self setlethalweapon("iw9_throwknife_mp");
		self maps\mp\gametypes\_class::giveoffhand("iw9_throwknife_mp");
		self setWeaponAmmoClip("iw9_throwknife_mp", 0);
	}
	maps\mp\_utility::giveperk("specialty_tacticalinsertion", 0 );
	self settacticalweapon("flare_mp");
	self maps\mp\gametypes\_class::giveoffhand("flare_mp");
	self setWeaponAmmoClip("flare_mp", 1);
	self giveWeapon(level.zombieknife, 0, false);
	wait 0.1;
	self switchtoWeapon(level.zombieknife);
}
giveZombiePerks()
{
	if(self.zombieSkills["flying"])
		self thread flyingZombie();
	maps\mp\_utility::givePerk("specialty_longersprint");
	maps\mp\_utility::givePerk("specialty_fastmantle");
	maps\mp\_utility::givePerk("specialty_extendedmelee");
	maps\mp\_utility::givePerk("specialty_falldamage");
	self.moveSpeedScaler = 1.20;
}

assignWeapons(){
	level.weapon_secondary_shotguns = [];
	level.weapon_snipers = [];
	level.weapon_bolts = [];
	level.weapon_heavys = [];
	level.weapon_smgs = [];
	level.weapon_assaults = [];
	level.weapon_secondary_machine_pistols = [];
	level.weapon_pistols = [];
	foreach(weapon in level.weaponList){
		switch(maps\mp\_utility::getweaponclass(weapon)){
			case "weapon_secondary_shotgun":
				level.weapon_secondary_shotguns[level.weapon_secondary_shotguns.size] = weapon;
				level.weapon_secondary_shotguns++;
			break;
			case "weapon_sniper":
				if(isBoltAction(weapon)){
					level.weapon_bolts[level.weapon_bolts.size] = weapon;
					level.weapon_bolts++;
				}
				level.weapon_snipers[level.weapon_snipers.size] = weapon;
				level.weapon_snipers++;
			break;
			case "weapon_heavy":
				level.weapon_heavys[level.weapon_heavys.size] = weapon;
				level.weapon_heavys++;
			break;
			case "weapon_smg":
				level.weapon_smgs[level.weapon_smgs.size] = weapon;
				level.weapon_smgs++;
			break;
			case "weapon_assault":
				level.weapon_assaults[level.weapon_assaults.size] = weapon;
				level.weapon_assaults++;
			break;
			case "weapon_secondary_machine_pistol":
				level.weapon_secondary_machine_pistols[level.weapon_secondary_machine_pistols.size] = weapon;
				level.weapon_secondary_machine_pistols++;
			break;
			case "weapon_pistol":
				level.weapon_pistols[level.weapon_pistols.size] = weapon;
				level.weapon_pistols++;
			break;
		}
	}
	level.weaponsAssigned = true;
}

isBoltAction(weapon){
	if(
	weapon == "h2_cheytac_mp" ||
	weapon == "h2_m40a3_mp"
	)
		return true;
	else
		return false;
}

giveHumanWeapons()
{
	//self SetOffhandSecondaryClass( "none" );
	//self SetOffhandPrimaryClass( "none" );
	while(!level.weaponsAssigned)
		wait 0.1;
	self.weaponSlot = [];
	self.weaponSlot["Primary"] = level.weapon_smgs[randomInt(level.weapon_smgs.size)];
	self.weaponSlot["Secondary"] = level.weapon_secondary_shotguns[randomInt(level.weapon_secondary_shotguns.size)];
	self.weaponSlot["Pistol"] = level.weapon_pistols[randomInt(level.weapon_pistols.size)];

	//self iPrintLn(self.weaponSlot["Primary"]);
	self _giveweapon(self.weaponSlot["Primary"]);
	self _giveweapon(self.weaponSlot["Secondary"]);
	self _giveweapon(self.weaponSlot["Pistol"]);
	self GiveMaxAmmo(self.weaponSlot["Primary"]);
	self GiveMaxAmmo(self.weaponSlot["Secondary"]);
	self GiveMaxAmmo(self.weaponSlot["Pistol"]);
	while(self getCurrentWeapon() != self.weaponSlot["Primary"]){
		wait 0.1;
		self switchToWeapon(self.weaponSlot["Primary"]);
	}
}

giveHumanPerks()
{
	maps\mp\_utility::givePerk("specialty_heartbreaker");
	maps\mp\_utility::givePerk("specialty_quieter");
	maps\mp\_utility::givePerk("specialty_longersprint");
	maps\mp\_utility::givePerk("specialty_fastmantle");
	maps\mp\_utility::givePerk("specialty_extendedmelee");
	maps\mp\_utility::givePerk("specialty_falldamage");
}

SetVision()
{
	self endon("disconnect");
	while(level.gameState == "starting")
		wait 0.1;
	
	while(level.gameState != "starting" && !level.nukeIncoming){
		if(self.team == "allies"){
            if(self.humanSkills["nightv"])
                self VisionSetNakedForPlayer("default_night_mp", 0);
            else if(level.BlackoutHumans)
                self VisionSetNakedForPlayer("black_bw", 0);
            else
                self VisionSetNakedForPlayer(level.humanVision, 0);
        }
		else if(self.team == "axis")
			self VisionSetNakedForPlayer(level.zombieVision, 0);
		wait 0.25;
	}
}

resetVariables(){
	self.menu = 0;
	self.humanSkills["freezeZombies"] = 0;
	self.hashelpwithbuttons = 0;
	self.AlphaZombie = 0;

	if(!isDefined(self.Mines))
		self.Mines= 0;

	//Both Human and Zombie Vars
	self ThermalVisionFOFOverlayOff();

	//Zombie Vars
	self.zombieSkills = [];
	self.zombieSkills["FastTacTime"] = 2.4;
	self.tacWeapon = "m16_fmj_thermal_mp";

	self.zombieSkills["thermal"] = false;
	self.zombieSkills["knife"] = false;
	self.zombieSkills["radio"] = false;
	self.zombieSkills["flame"] = false;
	self.zombieSkills["flying"] = false;
	self.zombieSkills["invis"] = false;
	self.zombieSkills["blackouth"] = false;
	self.zombieSkills["predator"] = false;
	self.zombieSkills["1500health"] = false;

	//Human Vars
	self.humanSkills = [];
	self.humanSkills["mine"] = false;
	self.humanSkills["nightv"] = false;
	self.humanSkills["thermal"] = false;

	self.humanSkills["freezeZombies"] = false;

	self.humanSkills["ExplosiveDesertEagle"] = false;

	self.humanSkills["StringerPro"] = false;
	self.humanSkills["bow"] = false;
	self.humanSkills["infammo"] = false;
	self.humanSkills["ac130"] = false;
	self.humanSkills["raygun"] = false;
	self.humanSkills["thundergun"] = false;
	self.humanSkills["nuke"] = false;
	self.humanSkills["uav"] = false;

	self.perkz=[];
	self.perkz["claymore"] = 0;
	self.perkz["steadyaim"] = 0;
	self.perkz["stoppingpower"] = 0;
	self.perkz["sitrep"] = 0;
	self.perkz["sleightofhand"] = 0;
	self.perkz["ninja"] = 0;
	self.perkz["lightweight"] = 0;
	self.perkz["coldblooded"] = 0;

	self setactionslot( 0, "" );
	self setactionslot( 1, "" );
	self setactionslot( 2, "" );
	self setactionslot( 3, "" );
	self setactionslot( 4, "" );

	//Human Weapon Attachments
	self.weaponAttachment = [];
	self.weaponAttachment["Primary"] = "none";
	self.weaponAttachment["Secondary"] = "none";
	self.weaponAttachment["Pistol"] = "none";
	
	if(!isdefined(self.money))
		self.money = 0;
}

setVariables(){
	self.hittingDoor = false;
	//self setSafeMSGText("");
	if(level.dev)
		self.money = 1000000;
}

setupFirstTimeZombie()
{
	if(!self.firstZombieSpawn)
	{
		self.firstZombieSpawn = true;
		self thread zombieOverlay();
		self maps\mp\gametypes\_menus::menuClass( "sniper_mp,0" );
		notifySpawn = spawnstruct();
		self.speedScale = 1;
		if(!isdefined(self.zKills))
			self.zKills = self.kills;
		if(!isdefined(self.zDeaths))
			self.zDeaths = self.deaths;
		if(!isdefined(self.zSuicides))
			self.zSuicides = self.suicides;
		if(self.AlphaZombie)
		{
			self.money=150;
			notifySpawn.titleText = "^1You're An ^2Alpha ^1Zombie!";
		}
		else
		{
			self.money=50;
			notifySpawn.titleText = "^1You're A Zombie!";
		}
		if(level.dev)
			self.money = 1000000;	
		notifySpawn.notifyText = "^1Earn Money By Dying & Killing!";
		notifySpawn.duration = 5;
		self thread maps\mp\gametypes\_hud_message::notifyMessage( notifySpawn );
		
		if(self.AlphaZombie)
		{
			wait 5;
			notifySpawn = spawnstruct();
			notifySpawn.titleText = "^1Alpha Zombies Money Set To 150!";
			notifySpawn.notifyText = "^1Alpha Zombies Health Set To 200";
			//notifySpawn.glowColor = (0.0, 0.0, 0.0);
			notifySpawn.duration = 5;
			self thread maps\mp\gametypes\_hud_message::notifyMessage( notifySpawn );
		}
	}
}

updateMenuInfoDvars(){
	self endon("disconnect");
	self setClientDvar("ui_name_width", 523);
	self setClientDvar("ui_name", self.name);
	setDvar(self.guid+"_money", -1);
	setDvar(self.guid+"_health", -1);
	setDvar(self.guid+"_round", -1);
	setDvar(self.guid+"_team", -1);
	while(1){
		if(getDvarInt(self.guid+"_money") != self.money){
			setDvar(self.guid+"_money", self.money);
			self setClientDvar("ui_money", self.money);
		}
		if(getDvarInt(self.guid+"_health") != self.health){
			setDvar(self.guid+"_health", self.health);
			self setClientDvar("ui_health", self.health);
		}
		if(getDvarInt(self.guid+"_round") != level.roundz){
			setDvar(self.guid+"_round", level.roundz);
			self setClientDvar("ui_round", level.roundz);
		}
		/*if(getDvar(self.guid+"_name") != self.name){
			setDvar(self.guid+"_name", self.name);
			self setClientDvar("ui_name", self.name);
			if(self.name.size <= 8)
				self setClientDvar("ui_name_width", 85);
			else{
				customWidth = 85;
				for(i=0;i<(self.name.size-8);i++)
					customWidth+=5.8;
				self setClientDvar("ui_name_width", customWidth);
			}
		}*/
		if(getDvar(self.guid+"_team") != self.team){
			setDvar(self.guid+"_team", self.team);
			if(self.team == "allies")
				self setClientDvar("ui_team", "Humans");
			else if(self.team == "axis")
				self setClientDvar("ui_team", "Zombies");
			else
				self setClientDvar("ui_team", "None");
		}
		wait 0.025;
	}
}

doAlphaZombie()
{
	self.HawkinZombie = true;
	self.AlphaZombie = true;
	self maps\mp\gametypes\_menus::addToTeam( "axis" );
	self.maxhp = 200;
	self _suicide();
}
/* Round Control End */ 

doGodzs()
{
	self endon ( "disconnect" );
	while ( level.gameState == "intermission" || level.gameState == "starting" )
	{
		self.maxhealth = 9000;
		self.health = self.maxhealth;
		wait 1;
	}
	self.maxhealth = 200;
	self.health = self.maxhealth;
}